<?php 
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */
    
    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "../../../classi/ecommerce/Prodotto.php";
    
    if(isset($_GET["id"])) {
        $prodotto = new Prodotto($geecomDb, filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $prodotto->caricaDatiDalDatabase();
    }
    else {
        $prodotto = new Prodotto($geecomDb,0);
        $impostazioniLingue = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue",1);
        $prodotto->setLingua($impostazioniLingue["linguaPrincipale"]);
    }
    
    $impostazioniAdmin     = $geecomDb->leggiSingolaRiga("geecAd_impostazioni",1);
    $impostazioniEcommerce = $geecomDb->leggiSingolaRiga("geecEc_impostazioni",1);
    $tipoElemento      = "prodotto";
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Componente e-commerce - Creazione prodotto</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                    
                    <div class="row py-4">
                        <?php 
                            if($status==275) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Prodotto modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==280) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Prodotto duplicato, modificalo per non avere due prodotti uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==320) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Traduzione creata, inserisci i testi nella lingua da te scelta
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==350) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Componente creato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==360) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Componente aggiornato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==370) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento duplicato nel nuovo portfolio
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        <input type="text" class="d-none" id="operazione" value="modifica">

                        <div class="col-lg-8 ">
                            <div class="form-row mb-3">
                                <div class="col-md-7 d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="home.php">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">E-commerce</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">Prodotti</a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo(($prodotto->getId()>0) ? $prodotto->getNome() : "Nuovo prodotto")?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-md-5 text-right">
                                    <a class="btn btn-primary mr-1" href="creaProdotto.php">Crea nuovo<i class="fas fa-plus ml-2"></i></a>
                                    <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                </div>
                            </div>
                            
                            <form name="formProdotto" action="../../../controller/ecommerce/controllerProdotti.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo(($prodotto->getId()==0) ? "crea" : "modifica"); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo $prodotto->getId(); ?>">
                                
                                <div class="card mb-4 box-shadow-lite">
                                    <div class="card-header py-3">
                                        <div class="row mb-3">
                                            <div class="col-12 flex-lg-shrink-1 d-md-flex align-items-center">
                                                <label class="mr-3 mb-md-0">Nome:</label>
                                                <input type="text" class="form-control form-control-lg" id="nomeSlider" name="nome" aria-describedby="nome prodotto" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getNome() : "")) ?>" placeholder="Nome prodotto">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <?php 
                                                if($prodotto->getId()!=0) {
                                            ?>
                                            <div class="form-group col-md-5">
                                                <label for="titolo-articolo" id="labelAlias">Alias</label>
                                                <input  type="text" class="form-control" name="alias" value="<?php echo(($prodotto->getId()!=0? $prodotto->getAlias() : ""))?>" placeholder="Link">
                                            </div>

                                            <div class="form-group col-md-7">
                                                <label for="url-seo">URL</label>
                                                <input type="text" class="form-control" id="url-seo" name="alias" value="<?php echo GeneratoreUrl::creaUrlProdotto($prodotto->getDatiProdotto(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]) ?>" disabled="">
                                                <small class="text-muted"> l'URL a cui è raggiungibile il prodotto</small>
                                            </div>
                                            <?php
                                                }
                                            ?>

                                            <div class="form-group col-12">
                                                <label for="sottotitolo-articolo">Meta descrizione</label>
                                                <textarea class="form-control" id="descrizione" name="metaDescrizione" rows="2"><?php echo(($prodotto->getId()!=0? $prodotto->getMetaDescrizione() : ""))?></textarea>
                                                <small class="text-muted"> Inserisci una breve descrizione di questo contenuto, verrà mostrata nei risultati di ricerca di Google </small>
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label for="stato" class="d-block">Pubblicato</label>
                                                <input type="checkbox" id="pubblicato" name="pubblicato" class="js-switch" value="si" <?php echo((isset($prodotto) && $prodotto->getPubblicato()=="si") ? "checked" :"") ?> >
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card-body wrapper-sezioni-pagina">
                                        <div class="row">

                                            <?php
                                                $tipiProdotto = array("fisico","digitale","abbonamento");
                                            ?>
                                            <div class="form-group col-6">
                                                <label>Tipo</label>
                                                <select class="selectpicker w-100" name="tipo">
                                                    <?php
                                                        foreach($tipiProdotto as $tipo) {
                                                            if($prodotto->getId()!=0 && $prodotto->getTipoProdotto() == $tipo) {
                                                                $selezionato  = "selected";
                                                            }
                                                            else {
                                                                $selezionato  = "";
                                                            }
                                                            echo"<option value=\"$tipo\" $selezionato >{$tipo}</option>";
                                                        }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-6">
                                                <label>Fornitore</label>
                                                <div class="d-flex">
                                                    <select class="selectpicker w-100" name="idFornitore">
                                                        <option value="0">Nessuno</option>
                                                        <?php
                                                            $queryNomiTag = "SELECT * FROM geec_utenti WHERE ruolo LIKE 'utente' AND id IN (SELECT idUtente FROM geec_gruppiUtenti WHERE idGruppo={$impostazioniAdmin["gruppoFornitori"]} )";
                                                            $risNomi      = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                            while($utente = $risNomi->fetch_assoc()) {
                                                                if($prodotto->getId()!=0 && $prodotto->getIdFornitore() == $utente["id"]) {
                                                                    $selezionato  = "selected";
                                                                }
                                                                else {
                                                                    $selezionato  = "";
                                                                }
                                                                echo"<option value=\"{$utente["id"]}\" $selezionato >{$utente["nome"]} {$utente["cognome"]} - {$utente["organizzazione"]}</option>";
                                                            }
                                                        ?>
                                                    </select>
                                                    <?php 
                                                        if($prodotto->getId()!=0 && $prodotto->getIdFornitore() != 0) {
                                                    ?>
                                                            <a href="creaUtente.php?id=<?php echo $prodotto->getIdFornitore() ?>" class="align-self-center"><i class="fas fa-external-link-alt ml-2"></i></a>
                                                    <?php
                                                        }
                                                    ?>
                                                </div>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Codice prodotto:</label>
                                                <input type="text" class="form-control" id="nomeSlider" name="codiceProdotto" aria-describedby="codice prodotto" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getCodiceProdotto() : "")) ?>" placeholder="Codice">
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>EAN:</label>
                                                <input type="text" class="form-control" id="nomeSlider" name="ean" aria-describedby="ean" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getEan() : "")) ?>" placeholder="EAN">
                                            </div>

                                            <div class="form-group col-md-3">
                                                <label>Prezzo di acquisto €</label>
                                                <input type="number" class="form-control" id="nomeSlider" name="prezzoAcquisto" aria-describedby="nome prodotto" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getPrezzoAcquisto() : "0")) ?>" placeholder="Prezzo acquisto">
                                            </div>

                                            <div class="form-group col-md-3">
                                                <label>Prezzo di vendita €</label>
                                                <input type="number" class="form-control" id="nomeSlider" name="prezzo" aria-describedby="prezzo di vendita" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getPrezzo() : "0")) ?>" placeholder="Prezzo di vendita">
                                            </div>

                                            <div class="form-group col-md-3">
                                                <label>In offerta a €</label>
                                                <input type="number" class="form-control" id="nomeSlider" name="prezzoOfferta" aria-describedby="prezzo offerta" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getPrezzoOfferta() : "0")) ?>" placeholder="Prezzo unitario">
                                            </div>

                                            <div class="form-group col-md-3">
                                                <label>IVA</label>
                                                <?php
                                                	$ivaDaMostrareSeProdottoNuovo = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si") ? $impostazioniEcommerce["valorePredefinitoIva"] : 0;
                                                ?>
                                                <input type="number" class="form-control" id="iva" name="iva" aria-describedby="IVA" value="<?php echo(($prodotto->getId()>0 ? $prodotto->getIva() : "$ivaDaMostrareSeProdottoNuovo")) ?>" placeholder="IVA" <?= ($impostazioniEcommerce["aggiungiIvaProdotti"]!="si") ? "disabled" : "" ?>>
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label>Prezzo unitario €</label>
                                                <input type="number" class="form-control" id="nomeSlider" name="prezzoUnitario" aria-describedby="prezzo unitario" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getPrezzoUnitario() : "0")) ?>" placeholder="Prezzo unitario">
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label>Unità</label>
                                                <input type="text" class="form-control" id="nomeSlider" name="unita" aria-describedby="unita" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getUnita() : "")) ?>" placeholder="Unità">
                                            </div>

                                            <div class="w-100"></div>

                                            <div class="form-group col-md-4">
                                                <label for="stato" class="d-block">Prodotto inesauribile</label>
                                                <input type="checkbox" id="stato" name="prodottoInesauribile" class="js-switch" value="si" <?php echo((isset($prodotto) && $prodotto->getProdottoInesauribile()=="si") ? "checked" :"") ?> >
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label>Disponibilita</label>
                                                <input type="number" class="form-control" id="nomeSlider" name="disponibilita" aria-describedby="disponibilita" value="<?php echo(($prodotto->getId()!=0) ? $prodotto->getDisponibilita() : "0") ?>" placeholder="Elemento portfolio">
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label>Minimo ordine</label>
                                                <input type="number" class="form-control" id="nomeSlider" name="minimoAcquisto" aria-describedby="minimo ordine" value="<?php echo(($prodotto->getId()!=0) ? $prodotto->getMinimoAcquisto() : "1") ?>" placeholder="Elemento portfolio">
                                            </div>

                                            <div class="form-group col-6">
                                                <label for="select1" class="sottotitolo-articolo">Categoria</label>
                                                <select class="selectpicker w-100" name="categoria">
                                                    <option value="0">Nessuna</option>
                                                    <?php
                                                        $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND lingua LIKE '{$prodotto->getLingua()}' AND categoriaMadre=0 ORDER BY posizione ASC";
                                                        $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                        echo $queryNomiTag;
                                                        while($categoria = $risNomi->fetch_assoc()) {
                                                            if($prodotto->getId()!=0 && $prodotto->getCategoria() == $categoria["id"]) {
                                                                $selezionato  = "selected";
                                                            }
                                                            else {
                                                                $selezionato  = "";
                                                            }
                                                            echo"<option value=\"{$categoria["id"]}\" $selezionato >{$categoria["nome"]}</option>";
                                                            
                                                            $querySottoCategorie  = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                                                            $risSottoCategorie    = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                            while($sottoCategoria = $risSottoCategorie->fetch_assoc()) {
                                                                if($prodotto->getId()!=0 && $prodotto->getCategoria() == $sottoCategoria["id"]) {
                                                                    $selezionato  = "selected";
                                                                }
                                                                else {
                                                                    $selezionato  = "";
                                                                }
                                                                
                                                                echo"<option value=\"{$sottoCategoria["id"]}\" $selezionato > - {$sottoCategoria["nome"]}</option>";
                                                                
                                                                $querySottoCategorie  = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre={$sottoCategoria["id"]} ORDER BY posizione ASC";
                                                                $risSottoSottoCategorie    = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                                while($sottoSottoCategoria = $risSottoSottoCategorie->fetch_assoc()) {
                                                                    if($prodotto->getId()!=0 && $prodotto->getCategoria() == $sottoSottoCategoria["id"]) {
                                                                        $selezionato  = "selected";
                                                                    }
                                                                    else {
                                                                        $selezionato  = "";
                                                                    }

                                                                    echo"<option value=\"{$sottoSottoCategoria["id"]}\" $selezionato > -- {$sottoSottoCategoria["nome"]}</option>";
                                                                }
                                                            }
                                                        }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-6">
                                                <label for="select1" class="sottotitolo-articolo">Template</label>
                                                <select class="selectpicker w-100" name="template">
                                                    <?php
                                                        foreach($templateProdotti as $key=>$value) {
                                                            if(isset($prodotto) && $prodotto->getTemplate()==$value) {
                                                                echo"<option value=\"$value\" selected>$key </option>";						
                                                            }
                                                            else {
                                                                echo"<option value=\"$value\" >$key </option>";
                                                            }
                                                        }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="my-4">
                                            <textarea class="tiny" name="descrizione"><?php echo($prodotto->getId()!=0 ? $prodotto->getDescrizione() : "") ?></textarea>
                                        </div>

                                        <?php
                                            if(isset($prodotto) && $prodotto->getPubblicato()!="si") {
                                        ?>
                                                <button type="button" class="btn btn-success float-right ml-2 mt-3" onclick=pubblicaProdotto()><i class="fas fa-external-link-alt"></i> Pubblica</button>
                                        <?php
                                            }
                                        ?>
                                        <button type="button" class="btn btn-primary float-right mt-3" onclick="document.formProdotto.submit()"><i class="fas fa-check"></i> Salva</button>
                                    </div>
                                </div>

                                <div class="card mb-4 box-shadow-lite accordion">
                                    <div class="card-header collapsed" data-toggle="collapse" href="#caratteristicheAggiuntive">
                                        <a class="card-title">Caratteristiche aggiuntive</a>
                                    </div>
                                    <div id="caratteristicheAggiuntive" class="collapse show">
                                        <div class="card-body wrapper-sezioni-pagina">
                                            I campi inseriti in questa sezione, se compilati, saranno visualizzati nella scheda <b>Dettagli</b> se viene utilizzato il tema <b>template base</b> o <b>Colonna laterale in alto</b>

                                            <div class="my-4">
                                                <h5>Testo dettagli</h5>
                                                <textarea class="tiny" name="testoDettagli"><?php echo($prodotto->getId()!=0 ? $prodotto->getTestoDettagli() : "") ?></textarea>
                                            </div>

                                            <div class="row">

                                                <div class="form-group col-md-4">
                                                    <label>Marca</label>
                                                    <input type="text" class="form-control" id="nomeSlider" name="marca" aria-describedby="minimo ordine" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getMarca() : "")) ?>" placeholder="Marca">
                                                    <small class="text-muted">Lascia vuoto per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Modello</label>
                                                    <input type="text" class="form-control" id="nomeSlider" name="modello" aria-describedby="modello" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getModello() : "")) ?>" placeholder="Modello">
                                                    <small class="text-muted">Lascia vuoto per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Formato</label>
                                                    <input type="text" class="form-control" id="nomeSlider" name="formato" aria-describedby="formato" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getFormato() : "")) ?>" placeholder="Formato">
                                                    <small class="text-muted">Lascia vuoto per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Materiale</label>
                                                    <input type="text" class="form-control" id="nomeSlider" name="materiale" aria-describedby="materiale" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getMateriale() : "")) ?>" placeholder="Materiale">
                                                    <small class="text-muted">Lascia vuoto per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Colore</label>
                                                    <input type="text" class="form-control" id="nomeSlider" name="colore" aria-describedby="colore" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getColore() : "")) ?>" placeholder="Colore">
                                                    <small class="text-muted">Lascia vuoto per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Larghezza (cm)</label>
                                                    <input type="number" class="form-control" id="nomeSlider" name="larghezza" aria-describedby="larghezza" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getLarghezza() : "0")) ?>" placeholder="Larghezza">
                                                    <small class="text-muted">Lascia 0 per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Altezza (cm)</label>
                                                    <input type="number" class="form-control" id="nomeSlider" name="altezza" aria-describedby="altezza" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getAltezza() : "0")) ?>" placeholder="Altezza">
                                                    <small class="text-muted">Lascia 0 per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Profondità (cm)</label>
                                                    <input type="number" class="form-control" id="nomeSlider" name="profondita" aria-describedby="profondità" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getProfondita() : "0")) ?>" placeholder="Elemento portfolio">
                                                    <small class="text-muted">Lascia 0 per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Peso (kg)</label>
                                                    <input type="number" class="form-control" id="nomeSlider" name="peso" aria-describedby="peso" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getPeso() : "0")) ?>" placeholder="Elemento portfolio">
                                                    <small class="text-muted">Lascia 0 per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Peso volumetrico (kg)</label>
                                                    <input type="number" step="0.01" class="form-control" id="nomeSlider" name="pesoVolumetrico" aria-describedby="peso volumetrico" value="<?php echo(($prodotto->getPesoVolumetrico()!=0 ? $prodotto->getPesoVolumetrico() : "0")) ?>" placeholder="Peso volumetrico">
                                                    <small class="text-muted">Lascia 0 per non mostrare nulla</small>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label>Capacità (l)</label>
                                                    <input type="number" class="form-control" id="nomeSlider" name="capacita" aria-describedby="capacità" value="<?php echo(($prodotto->getId()!=0 ? $prodotto->getCapacità() : "0")) ?>" placeholder="Capacità">
                                                    <small class="text-muted">Lascia 0 per non mostrare nulla</small>
                                                </div>
                                                
                                            </div>
                                            
                                            <div class="text-right">
                                                <button type="button" class="btn btn-primary" onclick="document.formProdotto.submit()"><i class="fas fa-check"></i> Salva</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </form>
                                          
                            <?php 
                                // queste sezioni si devono vedere solo se il prodotto è stato già creato
                                if($prodotto->getId()!=0) {
                            ?>
                            <div class="card mb-4 box-shadow-lite accordion">
                                <div class="card-header" data-toggle="collapse" href="#immaginiProdotto">
                                    <a class="card-title" >Immagini associate</a>
                                </div>
                                <div id="immaginiProdotto" class="collapse show">
                                    <div class="card-body">

                                        <form action="../../../controller/ecommerce/controllerProdotti.php" id="frmFileUpload-00" class="dropzone singolo-file mb-3" method="post" enctype="multipart/form-data">
                                            <div class="dz-message">
                                                <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                <h5>Trascina o carica qui le immagini</h5>
                                            </div>
                                            <div class="fallback">
                                                <input name="file" type="file" />
                                            </div>
                                        </form>

                                        <div id="divElencoImmagini" class="gerarchia-menu">
                                            <?php 
                                                $prodotto->stampaImmaginiProdotto();
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                
                            <div class="card mb-4 box-shadow-lite accordion">
                                <div class="card-header" data-toggle="collapse" href="#attributiProdotto">
                                    <a class="card-title">Attributi</a>
                                </div>
                                <div id="attributiProdotto" class="collapse show">
                                    <div class="card-body">
                                        <div id="divAttributi">
                                            <?php  $prodotto->stampaAttributi() ?>
                                        </div>

                                        <form>
                                            <div class="add-box">
                                                <h6 class="mb-3"> Aggiungi attributo</h6>
                                                <div class="options-box form-row mb-0">

                                                    <div class="col-md-3">
                                                        <label for="nome-voce-menu-1">Nome</label>
                                                        <input type="text" class="form-control" id="nomeAttributo">
                                                    </div>

                                                    <div class="col-md-4">
                                                        <label for="nome-voce-menu-1">Valori attributo</label>
                                                        <input type="text" class="form-control" id="valoriAttributo">
                                                        <small class="text-muted">Inserisci i valori dell'attributo separati da una virgola</small>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <label for="nome-voce-menu-1">Costi attributo €</label>
                                                        <input type="text" class="form-control" id="costiAttributo">
                                                        <small class="text-muted">Inserisci i costi dell'attributo separati da una virgola</small>
                                                    </div>

                                                    <div class="col-md-2">                                   
                                                        <label for="">&nbsp;</label>
                                                        <button type="button" class="btn btn-primary btn-block" value="Aggiungi"  onclick="creaAttributo()"><i class="fas fa-plus mr-2"></i>Aggiungi</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="card-footer text-right">
                                        <button type="button" class="btn btn-primary" onclick="creaTutteLeVariazioni()"><i class="far fa-plus-square mr-2"></i>Crea tutte le variazioni</button>
                                    </div>
                                </div>
                            </div>
                
                            <div class="card mb-4 box-shadow-lite accordion">
                                <div class="card-header" data-toggle="collapse" href="#variazioniProdotto">
                                    <a class="card-title mb-0">Variazioni</a>
                                </div>
                                <div id="variazioniProdotto" class="collapse show">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <input type="checkbox" id="usaVariazioni" onchange="aggiornaUsaVariazioni()" class="js-switch" value="si" <?php echo((isset($prodotto) && $prodotto->getUsaVariazioni()=="si") ? "checked" :"") ?> >
                                            <label for="stato" class="ml-2">Usa variazioni</label>
                                        </div>
                                        <div id="divVariazioni" <?php echo((isset($prodotto) && $prodotto->getUsaVariazioni()!="si") ? "class=\"d-none\"" :"") ?> >
                                            <?php $prodotto->stampaVariazioni() ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card mb-4 box-shadow-lite accordion">
                                <div class="card-header" data-toggle="collapse" area-expanded="true" href="#componentiAggiuntivi">
                                    <a class="card-title">Componenti aggiuntivi</a>
                                </div>
                                <div id="componentiAggiuntivi" class="collapse show">
                                    <div class="card-body wrapper-sezioni-pagina">
                                        <div id="componentiContenuto">
                                            <?php $prodotto->stampaComponentiProdotto(); ?>
                                        </div>
                                        <button type="button" class="btn btn-success btn-block" data-toggle="modal" data-target="#aggiungi-componente-articolo"><i class="fas fa-plus"></i> Aggiungi un componente</button>
                                    </div>
                                </div>
                            </div>
                            <?php 
                                }
                            ?>
                        </div>
                        <!-- Colonna principale -->

                        <!--Colonna secondaria -->
                        <div class="col-lg-4  align-self-start sticky-top">
                            <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-primary w-100" onclick="document.formProdotto.submit()"><i class="fas fa-check mr-2"></i>Salva</button>
                                <?php 
                                    if($prodotto->getId()!=0) {
                                ?>
                                        <button type="button" class="btn btn-warning w-100" onclick="location.href='../../../controller/ecommerce/controllerProdotti.php?id=<?php echo $prodotto->getId() ?>&operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                        <a class="btn btn-secondary w-100" href="<?php echo GeneratoreUrl::creaUrlProdotto($prodotto->getDatiProdotto(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]) ?>"><i class="fas fa-external-link-square-alt mr-2"></i>Visualizza</a>
                                <?php
                                    }
                                ?>
                            </div>
                            <div class="clearfix"></div>

                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#divImmagineInEvidenza">
                                    <a class="card-title">
                                        Immagine in evidenza
                                    </a>
                                </div>
                                <div id="divImmagineInEvidenza" class="collapse show">
                                    <div class="card-body">
                                        <div class="img-container">
                                            <div class="azioni">
                                                <div class="btn-group" role="group" aria-label="">
                                                    <button onclick="eliminaImmagineInEvidenza()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                </div>
                                            </div>
                                            
                                            <img id="immagineInEvidenza" class="img-fluid w-100 mb-3" src="../../../<?php echo(($prodotto->getId()!=0 && $prodotto->getImmagineInEvidenza()!="") ? $prodotto->getImmagineInEvidenza() : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <?php 
                                if(isset($prodotto) && $prodotto->getId()!=0) {
                            ?>
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#traduzioni" aria-expanded="false">
                                    <a class="card-title">
                                        Traduzioni
                                    </a>
                                </div>
                                <div id="traduzioni" class="collapse show" style="">
                                    <div class="card-body ">

                                        <div class="d-flex justify-content-between  align-items-center">
                                            <span>Questo prodotto è in <strong><?php echo strtoupper($prodotto->getLingua()) ?></strong> </span>
                                            <img src="../../../<?php echo percorsoImmagineBandiera($prodotto->getLingua()) ?>" alt="<?php echo $prodotto->getLingua() ?>">
                                        </div>
                                        <div id="boxTraduzioni">
                                        <?php 
                                            if(isset($prodotto)) {
                                                $prodotto->stampaBoxTraduzioni();
                                            }
                                        ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                                }
                            ?>
                        </div>
                </div>

            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";
                        
            include "../include/modal/eliminaElemento.php";
        ?>
        
        <div class="modal fade" id="modalEliminaVariazione" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Conferma eliminazione</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomeVariazioneDaEliminare"></em></span>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="variazioneDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneVariazione()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="aggiungi-componente-articolo" class="modal fade" tabindex="-1" aria-labelledby="aggiungi un componente" aria-hidden="true" role="dialog">
            <div class="modal-dialog modal-xl" role="document">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Aggiungi un componente</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="form-row d-flex align-items-stretch">
                            <?php 
                                $queryComponenti = "SELECT * FROM geecB_componenti WHERE componenteArticolo LIKE 'si'";
                                $risComponenti = $geecomDb->eseguiQueryLettura($queryComponenti);

                                while($componente = $risComponenti->fetch_assoc()) {
                                    echo"<div class=\"col-6 col-sm-4 col-md-3 col-lg-2 col-xl-1 my-1\">
                                        <a href=\"{$percorsoBase}../controller/ecommerce/controllerProdotti.php?operazione=aggiungiComponentePagina&idPagina={$prodotto->getId()}&idComponente={$componente["id"]}&tipoElemento=$tipoElemento\" class=\"btn btn-light btn-block\">"
                                        . "<img class=\"img-fluid\" src=\"$percorsoBase{$componente["icona"]}\">"
                                        . "<h6>{$componente["nome"]}</h6>
                                        </a>
                                    </div>";
                                }
                            ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Annulla</button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="modalEliminaImmagine" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare l'immagine?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="percorsoImmagineDaEliminare" class="img-fluid" src="">
                        </div>
                        <input type="text" class="d-none" id="idImmagineDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOccorrenzaImmagine('../../../')"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="modalEliminaComponente" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare il componente?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center">
                                <span class="mr-3 align-self-center text-primary"><em id="nomeComponenteDaEliminare"></em></span>
                                <div id="nomeElementoDaEliminare"></div>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="componenteDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneComponentePagina()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        <?php 
        
            $contenuto = $prodotto;
            include "../../include/modalModificheComponenti.php";
        ?>
        <!-- Modifica impostazioni sezione -->
        <div class="modal fade" id="modifica-impostazioni-sezione" tabindex="-1" role="dialog" aria-labelledby="modifica impostazioni sezione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Opzioni sezione</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form name="formImpostazioniSezione" action="../../../controller/ecommerce/controllerProdotti.php" method="post" enctype="multipart/form-data">
                            <input type="text" class="d-none" name="id" value="<?php echo((isset($contenuto)) ? $contenuto->getId() : "0") ?>">
                            <input type="text" class="d-none" id="idSezioneDaModificare" name="idSezioneDaModificare">
                            <input type="text" class="d-none" name="operazione" value="modificaOpzioniSezione">
                            <div class="form-group row">
                                  <label for="idSezione" class="col-sm-2 col-form-label">ID</label>
                                  <div class="col-sm-10">
                                    <input type="text" class="form-control" id="idSezione" name="idSezione" placeholder="ID">
                                    <small class="form-text text-muted"> L'ID deve essere unico </small>
                                  </div>
                            </div>
                            <div class="form-group row">
                                  <label for="classeSezione" class="col-sm-2 col-form-label">Classi</label>
                                  <div class="col-sm-10">
                                    <input type="text" class="form-control" id="classeSezione" name="classeSezione" placeholder="classi">
                                    <small class="form-text text-muted"> Inserisci le classi aggiuntive separate da uno spazio, ad es.: "mt-0 bg-dark text-negative"</small>
                                  </div>
                            </div>
                            <hr>
                            
                            <h6> Colore di sfondo </h6>
                            <div class="form-row">
                                <div class="form-group col-sm-6">
                                    <div id="divContenitoreColorPicker" class="">

                                    </div>
                                    <small class="form-text text-muted">Se non impostato la sezione avrà uno sfondo trasparente</small>
                                </div>
                                <div class="form-group col-sm-6">
                                    <select class="form-control" id="colore-predefinito-valore" onchange="aggiornaColoreSezione()">
                                        <option value="">Seleziona tra i colori predefiniti</option>
                                        <option value="<?php echo $configurazioneAspetto["colorePrimario"] ?>">Primary</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreSecondario"] ?>">Secondary</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreSuccess"] ?>">Success</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreDanger"] ?>">Danger</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreWarning"] ?>">Warning</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreInfo"] ?>">Info</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreDark"] ?>">Dark</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreLight"] ?>">Light</option>
                                    </select>
                                </div>
                            </div>

                            <hr class="mt-0">
                            <div class="form-row">
                                <div class="form-group col-sm-9">
                                    <h6> Immagine di sfondo </h6>
                                    <input name="file" type="file" accept="image/*"/>
                                    <small class="d-block text-muted form-text">Se presente, l'immagine di sfondo verrà visualizzata al posto del video sui dispositivi che non ne consentono la riproduzione.</small>
                                </div>
                                <div class="form-group col-sm-3">
                                    <div class="img-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaImmagineSezione()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <img id="immagineDiSfondoSezione" class="img-fluid"  alt="immagine sezione">
                                    </div>
                                </div>
                            </div>

                            <hr class="mt-0">
                            <div class="form-row">
                                <div class="form-group col-sm-9">
                                    <h6> Video di sfondo </h6>
                                    <input name="video" type="file" accept="video/*" />
                                </div>
                                <div class="form-group col-sm-3">
                                    <div class="video-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaVideoSezione()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <video id="videoDiSfondoSezione" class="embed-responsive embed-responsive-16by9" poster="../../../immagini/altro/segnaposto.png" >
                                            <source id="sorgenteVideoDiSfondo" src="" type="video/mp4">
                                        </video>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                          <button type="button" class="btn btn-primary btn-sm" onclick="document.formImpostazioniSezione.submit()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                  </div>
            </div>
        </div>
        <?php
            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg,.webp",
                maxFiles: 10,
                parallelUploads: 10,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    this.removeAllFiles();
                    aggiornaDivImmagini();
                },
                params:{
                    operazione:"aggiungiFotoProdotto",
                    id:<?php echo $prodotto->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function pubblicaProdotto() {
                if($('#titolo-articolo').val()=="") {
                    alert("Inserisci il titolo");
                }
                else {
                    document.getElementById("pubblicato").checked = true;
                    document.formProdotto.submit();
                }
            }
            
            function aggiornaDivImmagini() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"stampaFotoProdotto",
                        id:<?php echo $prodotto->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("divElencoImmagini").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function creaAttributo() {
                var nomeAttributo   = $('#nomeAttributo').val();
                var valoriAttributo = $('#valoriAttributo').val();
                var costiAttributo  = $('#costiAttributo').val();
                
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"aggiungiAttributo",
                        id:<?php echo $prodotto->getId() ?>,
                        nome:nomeAttributo,
                        valori:valoriAttributo,
                        costi:costiAttributo
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivAttributi();
                            $('#nomeAttributo').val("");
                            $('#valoriAttributo').val("");
                            $('#costiAttributo').val("");
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function aggiornaDivAttributi() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"stampaAttributi",
                        id:<?php echo $prodotto->getId() ?>,
                    },
                    success:function(result) {
                        document.getElementById("divAttributi").innerHTML = result;
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert(xhr.status+" "+thrownError);
                    }
                });
            }
            
            function aggiornaDivVariazioni() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"stampaVariazioni",
                        id:<?php echo $prodotto->getId() ?>,
                    },
                    success:function(result) {
                        document.getElementById("divVariazioni").innerHTML = result;
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert(xhr.status+" "+thrownError);
                    }
                });
            }
            
            function eliminaElemento(id,nomeElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"eliminaAttributo",
                        id:<?php echo $prodotto->getId() ?>,
                        idAttributo:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("attributoProdotto"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
       
            function modificaAttributo(id) {
                var nome   = $('#nomeAttributoDaModificare'+id).val();
                var valori = $('#valoriAttributoDaModificare'+id).val();
                var costi  = $('#costiValoriAttributoDaModificare'+id).val();
                
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"modificaAttributo",
                        id:<?php echo $prodotto->getId() ?>,
                        idAttributo:id,
                        nome:nome,
                        valori:valori,
                        costi:costi
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("labelOperazioneCompletata").innerHTML = "Attributo prodotto aggiornato";
                            $('#modalOperazioneCompletata').modal('show');
                        }
                        else {
                            alert(result)
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaVariazioni(idAttributo) {
                
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"creaVariazioni",
                        id:<?php echo $prodotto->getId() ?>,
                        idAttributo:idAttributo
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("labelOperazioneCompletata").innerHTML = "Variazioni create";
                            aggiornaDivVariazioni();
                            $('#modalOperazioneCompletata').modal('show');
                        }
                        else {
                            alert(result)
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaTutteLeVariazioni() {
                
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"creaTutteLeVariazioni",
                        id:<?php echo $prodotto->getId() ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("labelOperazioneCompletata").innerHTML = "Variazioni create";
                            aggiornaDivVariazioni();
                            $('#modalOperazioneCompletata').modal('show');
                        }
                        else {
                            alert(result)
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaVariazione(id,nomeElemento) {
                $('#variazioneDaEliminare').val(id);
                $('#nomeVariazioneDaEliminare').text(nomeElemento);
                $('#modalEliminaVariazione').modal('show');
            }
            
            function eseguiEliminazioneVariazione() {
                var id = $('#variazioneDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"eliminaVariazione",
                        id:<?php echo $prodotto->getId() ?>,
                        idVariazione:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("variazioneProdotto"+id).className = "d-none";
                            $('#modalEliminaVariazione').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
       
           function aggiornaUsaVariazioni() {
                var usaVariazioni = "no";
                if(document.getElementById("usaVariazioni").checked) {
                    usaVariazioni = "si";
                }
               
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"aggiornaUsaVariazioni",
                        id:<?php echo $prodotto->getId() ?>,
                        usaVariazioni:usaVariazioni
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            if(usaVariazioni=="si") {
                                document.getElementById("divVariazioni").className = "";
                            }
                            else {
                                document.getElementById("divVariazioni").className = "d-none";
                            }
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function modificaVariazione(id) {
                var codice   = $('#codiceVariazioneDaModificare'+id).val();
                var nome     = $('#nomeVariazioneDaModificare'+id).val();
                var quantita = $('#quantitaVariazioneDaModificare'+id).val();
                var costo    = $('#costoVariazioneDaModificare'+id).val();
                
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"modificaVariazione",
                        id:<?php echo $prodotto->getId() ?>,
                        idVariazione:id,
                        codiceVariazione:codice,
                        nomeVariazione:nome,
                        quantitaVariazione:quantita,
                        costoVariazione:costo
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("labelOperazioneCompletata").innerHTML = "Variazione prodotto aggiornata";
                            $('#modalOperazioneCompletata').modal('show');
                        }
                        else {
                            alert(result)
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function rendiImmagineInEvidenza(idProdotto,percorso) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"modificaImmagineInEvidenzaConPercorso",
                        id:idProdotto,
                        percorso:percorso
                    },
                    success:function(risposta) {
                        if(risposta=="ok") {
                            document.getElementById("immagineInEvidenza").src = "../../../"+percorso;
                        }
                        else {
                            alert(risposta);
                        }
                    }
                });
            }
        </script>

        <script>
            function modificaImpostazioniSezione(id,idSezione,classeSezione,coloreSfondo,immagineDiSfondo,videoDiSfondo) {
                document.getElementById("idSezioneDaModificare").value = id;
                document.getElementById("idSezione").value      = idSezione;
                document.getElementById("classeSezione").value  = classeSezione;
                
                var elementoSwitchModal = document.querySelector('.js-switch-modal');
                switchModalSezione  = new Switchery(elementoSwitchModal,{ size: 'small', color: 'var(--primary)', jackColor: '#FFF' });
                
                // creo il colorpicker
                if (typeof colorPickerSezione !== 'undefined') {
                    $('.selettore-colore').colorpicker('destroy');
                    
                    document.getElementById("divContenitoreColorPicker").innerHTML = "<input type=\"text\" id=\"coloreSfondo\" name=\"coloreSfondo\" class=\"form-control\" /><span class=\"input-group-append\"><span class=\"input-group-addon input-group-text\"><i></i></span></span>";
                    document.getElementById("divContenitoreColorPicker").className = "input-group colorpicker-component selettore-colore";
                    document.getElementById("coloreSfondo").value   = coloreSfondo;

                    colorPickerSezione = $('.selettore-colore').colorpicker({
                        format: 'hex'
                    });
                }
                else {
                
                    document.getElementById("divContenitoreColorPicker").innerHTML = "<input type=\"text\" id=\"coloreSfondo\" name=\"coloreSfondo\" class=\"form-control\" /><span class=\"input-group-append\"><span class=\"input-group-addon input-group-text\"><i></i></span></span>";
                    document.getElementById("divContenitoreColorPicker").className = "input-group colorpicker-component selettore-colore";
                    document.getElementById("coloreSfondo").value   = coloreSfondo;

                    colorPickerSezione = $('.selettore-colore').colorpicker({
                        format: 'hex'
                    });
                }
                
                if(immagineDiSfondo=="") {
                    document.getElementById("immagineDiSfondoSezione").src = "../immagini/altro/segnaposto.png";
                }
                else {
                    document.getElementById("immagineDiSfondoSezione").src = "../"+immagineDiSfondo;
                }
                
                var video = document.getElementById("videoDiSfondoSezione");
                if(videoDiSfondo=="") {
                    video.setAttribute('poster','../immagini/altro/segnaposto.png');
                    if (video.hasAttribute("controls")) {
                        video.removeAttribute("controls")   
                    }
                }
                else {
                    video.removeAttribute('poster');
                    if (!video.hasAttribute("controls")) {
                        video.setAttribute("controls","controls")   
                    }
                    document.getElementById("sorgenteVideoDiSfondo").src = "../"+videoDiSfondo;
                    video.load();
                }
                
                $('#modifica-impostazioni-sezione').modal('show');
            }

            function modificaPosizioneComponenteDaInput(idComponente) {
                var posizione = document.getElementById("posizioneComponente"+idComponente).value;
                modificaPosizioneComponente(idComponente,posizione);
            }

            function modificaPosizioneComponente(idComponente,posizione) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"modificaPosizioneComponente",
                        id:<?php echo $prodotto->getId() ?>,
                        idComponente:idComponente,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {                
                            aggiornaComponentiProdotto();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function duplicaComponente(idComponente) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"duplicaComponente",
                        id:<?php echo $prodotto->getId() ?>,
                        idComponente:idComponente
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaComponentiProdotto();
                        }
                        else if(esito=="ok,ricarica") {
                            location.reload();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function aggiornaComponentiProdotto() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"stampaComponentiProdotto",
                        id:<?php echo $prodotto->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("componentiContenuto").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function eliminaComponentePagina(id,immagineComponente,nomeComponente,nomeElemento) {
                $('#componenteDaEliminare').val(id);
                document.getElementById("immagineComponenteDaEliminare").src = immagineComponente;
                $('#nomeComponenteDaEliminare').text(nomeComponente);
                document.getElementById("nomeElementoDaEliminare").innerHTML = nomeElemento;
                $('#modalEliminaComponente').modal('show');
            }

            function eseguiEliminazioneComponentePagina() {
                var id = $('#componenteDaEliminare').val();
                $.ajax({
                    type:"GET",
                    url:"../../../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaComponente",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("componentePagina"+id).className = "d-none";
                            $('#modalEliminaComponente').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function eliminaImmagineInEvidenza() {
                $.ajax({
                    type:"GET",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"eliminaImmagineInEvidenza",
                        id:<?php echo $prodotto->getId() ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineInEvidenza").src="../../../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function traduci(id) {
                var l =$('#linguaTraduzione').val();
                
                if(l=="") {
                    alert("Seleziona una lingua");
                } 
                else {
                    location.href="../../../controller/ecommerce/controllerProdotti.php?id="+id+"&operazione=traduci&lingua="+l;
                }
            }

            function eliminaPagina(id,titoloPagina) {
                $('#paginaDaEliminare').val(id);
                $('#nomePaginaDaEliminare').text(titoloPagina);
                $('#modalEliminaTraduzione').modal('show');
            }

            function eseguiEliminazioneProdotto() {
                var id = $('#paginaDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"elimina",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("pagina"+id).className = "d-none";
                            $('#modalEliminaTraduzione').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function gestoreLinkPersonalizzato() {
                if(document.getElementById("linkPersonalizzato").checked) {
                    document.getElementById("divUrlContenuto").className = "d-none";
                    document.getElementById("labelAlias").innerHTML      = "URL";
                }
                else {
                    document.getElementById("divUrlContenuto").className = "form-group col-12";
                    document.getElementById("labelAlias").innerHTML      = "Alias";
                }
            }
            
            function modificaPosizioneImmagineProdotto(prefisso,idContenuto,idImmagine,posizione) {
                $.ajax({
                    type:"POST",
                    url:prefisso+"controller/ecommerce/controllerProdotti.php",
                    data:{
                        operazione:"modificaPosizioneImmagineProdotto",
                        id:idContenuto,
                        idImmagine:idImmagine,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivImmagini(); // questa funzione deve essere definita all'interno della pagina dell'elemento, non può essere generalizzata
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function cambiaIdElemento(idComponente) {
                var idElemento = $("#idElementoComponente"+idComponente).val();
                
                $.ajax({
                    type:"GET",
                    url:"../../../controller/controllerContenuti.php",
                    data:{
                        operazione:"cambiaIdElemento",
                        id:idComponente,
                        idElemento:idElemento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#labelOperazioneCompletata').text("Componente aggiornato con successo");
                            $('#modalOperazioneCompletata').modal('show');
                            aggiornaComponentiPagina();
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
